<?php

namespace VM\ApiBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use FOS\RestBundle\Controller\Annotations\View;
use VM\ApiBundle\Entity\CompanyAllegroCategoryItem;
use VM\ApiBundle\Entity\CompanyEmployee;
use VM\ApiBundle\Exceptions\ApiException;

class DepartmentsController extends AbstractController
{
    private $randomEmployeesCount = 100;

    /**
     * @View(serializerGroups={"employeesDetails"})
     */
    public function loadDepartmentsAction()
    {
        try
        {
            $User = $this->getUser();
            $MarketSegment = $User->getGroup()->getUser()->getMarketSegment();

            $departments = $MarketSegment->getDepartments();


            $response = array();

            foreach($departments as $Department)
            {
                $response[$Department->getId()] = array(
                    'department' => $Department
                    ,'employees' => array()
                );
            }

            $Company = $this->getApiGetter()->getUserCompanyOrFalse($this->getUser());
            foreach($Company->getCompanyEmployees() as $CompanyEmployee)
            {
                $response[$CompanyEmployee->getDepartmentId()]['employees'][] = $CompanyEmployee->getEmployee();
            }

            return array_values($response);
        }
        catch(\Exception $Exception)
        {
            throw new ApiException($Exception->getMessage(), $Exception->getCode());
        }
    }

    /**
     * @View(serializerGroups={"employeesDetails"})
     */
    public function getRandomEmployeesAction()
    {
        try
        {
            $count = $this->getDoctrine()->getRepository('VMApiBundle:Employee')->createQueryBuilder('e')->select('COUNT(e)')->getQuery()->getSingleScalarResult();
            $randId = rand(1,$count-$this->randomEmployeesCount);

            $QueryBuilder = $this->getDoctrine()->getRepository('VMApiBundle:Employee')->createQueryBuilder('e');
            $QueryBuilder
                ->select('e')
                ->where($QueryBuilder->expr()->eq('e.isWorker',0))
                ->andWhere($QueryBuilder->expr()->gt('e.id',$randId))
                ->setMaxResults($this->randomEmployeesCount)
            ;

            return $QueryBuilder->getQuery()->getResult();
        }
        catch(\Exception $Exception)
        {
            throw new ApiException($Exception->getMessage(), $Exception->getCode());
        }
    }

    /**
     * @View(serializerGroups={"employeesDetails"})
     */
    public function saveEmployeesAction()
    {
        $this->getDoctrine()->getConnection()->beginTransaction();
        try
        {
            $data = $this->getRequest()->request->getIterator()->getArrayCopy();

            $User = $this->getUser();
            $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);

            $Department = $this->getApiGetter()->getDepartment($data['departmentId']);

            $employees = $Company->getCompanyEmployees();


            foreach($data['employees'] as $employeeData)
            {
                $Employee = $this->getApiGetter()->getEmployee($employeeData['id']);


                if(!empty($employeeData['fired']))
                {
                    $CompanyEmployee = $this->getDoctrine()->getRepository('VMApiBundle:CompanyEmployee')->getCompanyEmployee($Company->getId(), $Department->getId(), $employeeData['id']);
                    if(!empty($CompanyEmployee))
                    {
                        $this->getDoctrine()->getManager()->remove($CompanyEmployee);
                    }
                }
                else if(!empty($employeeData['hired']))
                {
                    $CompanyEmployee = $this->getDoctrine()->getRepository('VMApiBundle:CompanyEmployee')->getCompanyEmployee($Company->getId(), $Department->getId(), $employeeData['id']);

                    if(empty($CompanyEmployee))
                    {
                        $CompanyEmployee = new CompanyEmployee();
                        $CompanyEmployee->setCompany($Company);
                        $CompanyEmployee->setDepartment($Department);
                        $CompanyEmployee->setEmployee($Employee);

                        $this->getDoctrine()->getManager()->persist($CompanyEmployee);
                    }
                }
            }

            $this->getDoctrine()->getManager()->flush();
            $this->getDoctrine()->getConnection()->commit();
            $this->getDoctrine()->getManager()->clear();

            return $this->getDoctrine()->getRepository('VMApiBundle:CompanyEmployee')->getCompanyDepartmentEmployees($Company->getId(), $Department->getId());
        }
        catch(\Exception $Exception)
        {
            $this->getDoctrine()->getConnection()->rollback();
            throw new ApiException($Exception->getMessage(), $Exception->getCode());
        }
    }

}
